<?php

//index.php

require_once 'dompdf/autoload.inc.php';

use Dompdf\Options;

include('pdf.php');
require_once 'config.php';

/*session is started if you don't write this line can't use $_Session  global variable*/


$pdf = new Pdf();
$options = new Options();
$options->set('isRemoteEnabled', true);
$options->set('chroot', '/reportepdf');
$options->set('isHtml5ParserEnabled', true);
$options->set('isRemoteEnabled', false);
$pdf = new Pdf($options);

//unlink($file_name);

//$nombre = $_POST["nombre"];
//$fechas =  $_POST["fecha"];
//$fecha = date("d-m-Y", strtotime($fechas));
//$id_empresa =  $_POST["id_empresa"];
//$supervisor =  $_POST["supervisor"];
//$turno =  $_POST["turno"];
//$id_inicio_operacion =  $_POST["id_inicio_operacion"];


$nombre = "David Sazo";
$fecha = "01-10-2020";
$id_empresa = 1;
$supervisor = "Joel Vergara";
$turno = "Tarde";
$id_inicio_operacion = 328;

$file_name = 'Informe resumen indicadores de operacion linea de descortezado turno de ' . $turno . '.pdf';



////TIEMPO DE TURNO ////////////
$queryInicioOperacion = "SELECT DATE_FORMAT(tiempo_inicio,'%H:%i'),DATE_FORMAT(tiempo_final,'%H:%i'),tiempo_inicio,tiempo_final FROM inicio_operacion WHERE id_inicio_operacion = $id_inicio_operacion ORDER BY id_inicio_operacion DESC LIMIT 1";
$resultInicioOperacion = mysqli_query($conexion, $queryInicioOperacion);
$rowInicioOperacion = mysqli_fetch_row($resultInicioOperacion);
$HoraI = $rowInicioOperacion[0];
$HoraF = $rowInicioOperacion[1];
///////////////////////////////////


///TROZOS //////////////
$queryTrozoproduc = "SELECT sum(trozo.volumen),count(trozo.id_trozo),(sum(trozo.diametro_menor)+sum(trozo.diametro_mayor))/2
FROM inicio_operacion 
INNER JOIN intermedia_operacion ON inicio_operacion.id_inicio_operacion = intermedia_operacion.id_operacion 
INNER JOIN intermedia_trozos ON intermedia_operacion.id_inter_operacion = intermedia_trozos.id_inter_operacion 
INNER JOIN trozo ON intermedia_trozos.id_trozo = trozo.id_trozo 
WHERE inicio_operacion.id_inicio_operacion = $id_inicio_operacion ORDER BY trozo.id_trozo DESC LIMIT 1";
$resultTrozoproduc = mysqli_query($conexion, $queryTrozoproduc);
$rowInicioTrozoproduc = mysqli_fetch_row($resultTrozoproduc);


$TotalVolumen = $rowInicioTrozoproduc[0];
$TotalTrozos = $rowInicioTrozoproduc[1];
$TotalDiamMedio = $rowInicioTrozoproduc[2] / 100;
///////////////////////////////

////TIEMPO PRODUCCION///////////////////
$tiempoinicio = new DateTime($rowInicioOperacion[2]);
$tiempofinal = new DateTime($rowInicioOperacion[3]);

$diff = $tiempofinal->diff($tiempoinicio);
$horastotal = round($diff->s / 3600 + $diff->i / 60 + $diff->h + $diff->days * 24, 2);


$produccion = $TotalVolumen / $horastotal;

$queryTiemProduccion = "SELECT IF(SEC_TO_TIME(SUM(TIME_TO_SEC(tiempo_produccion))) IS NULL,'00:00:00',SEC_TO_TIME(SUM(TIME_TO_SEC(tiempo_produccion)))) 
FROM tiempo 
WHERE id_inicio_operacion = $id_inicio_operacion AND tipo_tiempo = 3 ORDER BY id_tiempo DESC LIMIT 1";
$resultTiemProduccion = mysqli_query($conexion, $queryTiemProduccion);
$rowTiemProduccion = mysqli_fetch_row($resultTiemProduccion);

$TiempoProduccion = new DateTime($rowTiemProduccion[0]);
$tiempofinalProduccion = new DateTime("00:00:00");

$diffproduccion = $TiempoProduccion->diff($tiempofinalProduccion);
$horastotalProduccion = round($diffproduccion->s / 3600 + $diffproduccion->i / 60 + $diffproduccion->h, 1);
////////////////////////////////////////////////////

///////TIEMPO MUERTO//////////////////////
$queryTiemMuerto = "SELECT IF(SEC_TO_TIME(SUM(TIME_TO_SEC(tiempo_muerto))) IS NULL,'00:00:00',SEC_TO_TIME(SUM(TIME_TO_SEC(tiempo_muerto))))
FROM tiempo 
WHERE id_inicio_operacion = $id_inicio_operacion AND tipo_tiempo = 2 ORDER BY id_tiempo DESC LIMIT 1";
$resultTiemMuerto = mysqli_query($conexion, $queryTiemMuerto);
$rowTiemMuerto = mysqli_fetch_row($resultTiemMuerto);
$TiempoMuerto = new DateTime($rowTiemMuerto[0]);
$tiempofinalMuerto = new DateTime("00:00:00");

$diffmuerto = $TiempoMuerto->diff($tiempofinalMuerto);
$minutostotalmuerto1 = round($diffmuerto->h * 60 + $diffmuerto->i + $diffmuerto->s / 60, 1);
$horastotalmuerto1 = round($diffmuerto->s / 3600 + $diffmuerto->i / 60 + $diffmuerto->h, 1);

$queryTiemMuerto1 = "SELECT IF(SEC_TO_TIME(SUM(TIME_TO_SEC(tiempo_muerto))) IS NULL,'00:00:00',SEC_TO_TIME(SUM(TIME_TO_SEC(tiempo_muerto))))
FROM tiempo 
WHERE id_inicio_operacion = $id_inicio_operacion AND tipo_tiempo = 4 ORDER BY id_tiempo DESC LIMIT 1";
$resultTiemMuerto1 = mysqli_query($conexion, $queryTiemMuerto1);
$rowTiemMuerto1 = mysqli_fetch_row($resultTiemMuerto1);
$TiempoMuerto1 = new DateTime($rowTiemMuerto1[0]);
$tiempofinalMuerto1 = new DateTime("00:00:00");

$diffmuerto1 = $TiempoMuerto1->diff($tiempofinalMuerto1);
$minutostotalmuerto2 = round($diffmuerto1->h * 60 + $diffmuerto1->i + $diffmuerto1->s / 60, 1);
$horastotalmuerto2 = round($diffmuerto1->s / 3600 + $diffmuerto1->i / 60 + $diffmuerto1->h, 1);

$minutostotalmuerto = round($minutostotalmuerto1 + $minutostotalmuerto2, 1);
$horastotalmuerto = round($horastotalmuerto1 + $horastotalmuerto2, 1);
/////////////////////////////////////////////////


////////TIEMPO COLACION/////////////////
$queryTiemColacion = "SELECT IF(SEC_TO_TIME(SUM(TIME_TO_SEC(tiempo_muerto))) IS NULL,'00:00:00',SEC_TO_TIME(SUM(TIME_TO_SEC(tiempo_muerto))))
FROM tiempo 
WHERE id_inicio_operacion = $id_inicio_operacion AND tipo_tiempo = 1 ORDER BY id_tiempo DESC LIMIT 1";
$resultTiemColacion = mysqli_query($conexion, $queryTiemColacion);
$rowTiemColacion = mysqli_fetch_row($resultTiemColacion);
$tiempoiniciocolacion = new DateTime($rowTiemColacion[0]);
$tiempofinalcolacion = new DateTime("00:00:00");

$diffcolacion = $tiempofinalcolacion->diff($tiempoiniciocolacion);
$minutostotalcolacion = round($diffcolacion->h * 60 + $diffcolacion->i + $diffcolacion->s / 60, 1);
$horastotalcolacion = round($diffcolacion->s / 3600 + $diffcolacion->i / 60 + $diffcolacion->h, 1);


$queryColacion = "SELECT IF(SEC_TO_TIME(SUM(TIME_TO_SEC(turnos.duracion_colacion))) IS NULL,'00:00:00',SEC_TO_TIME(SUM(TIME_TO_SEC(turnos.duracion_colacion))))  FROM turnos 
INNER JOIN intermedia_turnos ON intermedia_turnos.id_turnos = turnos.id_turnos 
INNER JOIN inicio_operacion ON inicio_operacion.id_inter_turnos = intermedia_turnos.id_inter_turnos
WHERE inicio_operacion.id_inicio_operacion = $id_inicio_operacion ORDER BY inicio_operacion.id_inicio_operacion DESC LIMIT 1";
$resultColacion = mysqli_query($conexion, $queryColacion);
$rowColacion = mysqli_fetch_row($resultColacion);
$tiempocolacion = new DateTime($rowColacion[0]);
$finalcolacion = new DateTime("00:00:00");

$diffcolaciontiempo = $finalcolacion->diff($tiempocolacion);
$minutoscolacion = round($diffcolaciontiempo->h * 60 + $diffcolaciontiempo->i + $diffcolaciontiempo->s / 60, 1);
$horascolacion = round($diffcolaciontiempo->s / 3600 + $diffcolaciontiempo->i / 60 + $diffcolaciontiempo->h, 1);


$tiempomuertocolacion = 0;
$horasmuertocolacion = 0;


if ($minutostotalcolacion > $minutoscolacion) {
    $tiempomuertocolacion = $minutostotalcolacion - $minutoscolacion;
    $horasmuertocolacion = $horascolacion + $horastotalcolacion;
}

$tiempomuertotalminutos = round($tiempomuertocolacion + $minutostotalmuerto, 1);
$tiempomuertotalhoras = round($horasmuertocolacion + $horastotalmuerto, 1);
//////////////////////////////////////////////////////////////////////////////


////////////RITMO/////////////////////////////////////////
$queryritmo = "SELECT trozoxminuto
FROM ritmoxdiametro 
WHERE estado = 1 ORDER BY id_ritmoxdiametro DESC LIMIT 1";

$resultritmo = mysqli_query($conexion, $queryritmo);
$rowritmo = mysqli_fetch_row($resultritmo);

$Totalritmo = $rowritmo[0];

$ritmo = round(round(round(round($TotalTrozos / $horastotalProduccion, 5) / 60, 5) / $Totalritmo, 5) * 100, 0);
////////////////////////////////////////////////////////////


/////////FACTOR DE USO////////////////////////////////////////
$factor_uso = round(round(round($horastotal - $tiempomuertotalhoras, 3) / $horastotal, 3) * 100, 0);
////////////////////////////////////////////////////////////


////////FACTOR DE OPERACION////////////////////////////////////
$factor_operacion = round(round($ritmo * $factor_uso, 3) / 100, 0);
///////////////////////////////////////////////////////////////


//////TROZOS RECHAZADOS CURVATURA/////////////////////////////
$queryRechaCurva = "SELECT count(trozo.id_trozo)
FROM inicio_operacion 
INNER JOIN intermedia_operacion ON inicio_operacion.id_inicio_operacion = intermedia_operacion.id_operacion 
INNER JOIN intermedia_trozos ON intermedia_operacion.id_inter_operacion = intermedia_trozos.id_inter_operacion 
INNER JOIN trozo ON intermedia_trozos.id_trozo = trozo.id_trozo 
WHERE inicio_operacion.id_inicio_operacion = $id_inicio_operacion AND trozo.estado = 2 ORDER BY trozo.id_trozo DESC LIMIT 1";
$resultRechaCurva = mysqli_query($conexion, $queryRechaCurva);
$rowInicioRechaCurva = mysqli_fetch_row($resultRechaCurva);

$Totalrechazocurvatura = $rowInicioRechaCurva[0];
//////////////////////////////////////////////////////////////


//////TROZOS RECHAZADOS CONICIDAD/////////////////////////////
$queryRechaConi = "SELECT count(trozo.id_trozo)
FROM inicio_operacion 
INNER JOIN intermedia_operacion ON inicio_operacion.id_inicio_operacion = intermedia_operacion.id_operacion 
INNER JOIN intermedia_trozos ON intermedia_operacion.id_inter_operacion = intermedia_trozos.id_inter_operacion 
INNER JOIN trozo ON intermedia_trozos.id_trozo = trozo.id_trozo 
WHERE inicio_operacion.id_inicio_operacion = $id_inicio_operacion AND trozo.estado = 3 ORDER BY trozo.id_trozo DESC LIMIT 1";
$resultRechaConi = mysqli_query($conexion, $queryRechaConi);
$rowInicioRechaConi = mysqli_fetch_row($resultRechaConi);

$Totalrechazoconicidad = $rowInicioRechaConi[0];
//////////////////////////////////////////////////////////////


$fileContent = '<html>
<style>
    table.center {
        margin-left: auto;
        margin-right: auto;
    }
</style>

<body>
    <img width="180px" style="margin-left:550px;margin-top:-20px" src="data:image/jpeg;base64,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">
    <h2 style="font-family:Arial, Helvetica, sans-serif; margin-top:-60px">
        <center><u>Resumen indicadores <br>de<br> operación línea de descortezado<u></center>
    </h2>

    <br>

    <table class="center" style="width: 100%; margin-left:50px">

        <tr>
            <td style="font-size: 17px; font-family:Arial, Helvetica, sans-serif">Resumen turno:' . $turno . '</td>
            <td style="font-size: 17px; font-family:Arial, Helvetica, sans-serif">Fecha: ' . $fecha . '</td>
        </tr>
        <tr>
            <td style="font-size: 17px; font-family:Arial, Helvetica, sans-serif">Operador: ' . $nombre . '</td>
            <td style="font-size: 17px; font-family:Arial, Helvetica, sans-serif">Supervisor: ' . $supervisor . '</td>
        </tr>
        <tr>
            <td style="font-size: 17px; font-family:Arial, Helvetica, sans-serif">Hora inicio turno: ' . $HoraI . '</td>
            <td style="font-size: 17px; font-family:Arial, Helvetica, sans-serif">Hora termino turno: ' . $HoraF . '</td>
        </tr>
    </table>
    <br><br><br><br>
    <h3 style="font-family:Arial, Helvetica, sans-serif">
        1) Glosario y parámetros
    </h3>

    <table class="center" style="border-collapse: collapse;width: 100%;border: 0.05px solid black;font-size: 17px; font-family:Arial, Helvetica, sans-serif"">
        <tr >
        <td style=" border: 0.05px solid black;">
        <center>Item</center>
        </td>
        <td style=" border: 0.05px solid black;">
            <center>Sigla o parámetro</center>
        </td>
        <td style=" border: 0.05px solid black;">Concepto</td>
        </tr>
        <tr>
            <td>
                <center>1</center>
            </td>
            <td>
                <center>TT</center>
            </td>
            <td>
                Tiempo total del turno
            </td>
        </tr>
        <tr>
            <td>
                <center>2</center>
            </td>
            <td>
                <center>TE</center>
            </td>
            <td>
                Tiempo efectivo de trabajo
            </td>
        </tr>
        <tr>
            <td>
                <center>3</center>
            </td>
            <td>
                <center>TM</center>
            </td>
            <td>
                Tiempo muerto turno
            </td>
        </tr>
        <tr>
        <td>
            <center>4</center>
        </td>
        <td>
            <center>' . $Totalritmo . '</center>
        </td>
        <td>
            Diseño de ritmo base Nicholson
        </td>
    </tr>
    </table>
    <br>
    <h3 style="font-family:Arial, Helvetica, sans-serif">
        2) Resumen Indicadores de operación
    </h3>


    <table class="center" style="border-collapse: collapse;width: 100%;border: 0.05px solid black;font-size: 17px; font-family:Arial, Helvetica, sans-serif"">
        <tr >
        <td style=" border: 0.05px solid black;">
        <center>Item</center>
        </td>
        <td style=" border: 0.05px solid black;">Concepto</td>
        <td style=" border: 0.05px solid black;">
            <center>Unidad</center>
        </td>
        <td style=" border: 0.05px solid black;">
            <center>Valor</center>
        </td>
        </tr>
        <tr>
            <td>
                <center>1</center>
            </td>
            <td>Productividad</td>
            <td>
                <center>m3 st / h</center>
            </td>
            <td>
                <center>' . number_format($produccion, 1) . '</center>
            </td>
        </tr>
        <tr>
            <td>
                <center>2</center>
            </td>
            <td>Cantidad de trozos</td>
            <td>
                <center>c/u</center>
            </td>
            <td>
                <center>' . $TotalTrozos . '</center>
            </td>
        </tr>
        <tr>
            <td>
                <center>3</center>
            </td>
            <td>Tiempo total del turno TT</td>
            <td>
                <center>h</center>
            </td>
            <td>
                <center>' . number_format($horastotal, 1) . '</center>
            </td>
        </tr>
        <tr>
            <td>
                <center>4</center>
            </td>
            <td>Tiempo efectivo de trabajo TE</td>
            <td>
                <center>h</center>
            </td>
            <td>
                <center>' . $horastotalProduccion . '</center>
            </td>
        </tr>
        <tr>
            <td>
                <center>5</center>
            </td>
            <td>% ritmo (trozos/min)</td>
            <td>
                <center>%</center>
            </td>
            <td>
                <center>' . $ritmo . '</center>
            </td>
        </tr>
        <tr>
            <td>
                <center>6</center>
            </td>
            <td>Factor de uso (TT-TM)/TT</td>
            <td>
                <center>%</center>
            </td>
            <td>
                <center>' .  $factor_uso . '</center>
            </td>
        </tr>
        <tr>
            <td>
                <center>7</center>
            </td>
            <td>Factor de operación</td>
            <td>
                <center>%</center>
            </td>
            <td>
                <center>' . $factor_operacion . '</center>
            </td>
        </tr>
        <tr>
            <td>
                <center>8</center>
            </td>
            <td>trozos rechazados x curvatura</td>
            <td>
                <center>c/u</center>
            </td>
            <td>
                <center>' . $Totalrechazocurvatura . '</center>
            </td>
        </tr>
        <tr>
            <td>
                <center>9</center>
            </td>
            <td>trozos rechazados x conicidad</td>
            <td>
                <center>c/u</center>
            </td>
            <td>
                <center>' . $Totalrechazoconicidad . '</center>
            </td>
        </tr>
        <tr>
            <td>
                <center>10</center>
            </td>
            <td>Diámetro medio del turno</td>
            <td>
                <center>cm</center>
            </td>
            <td>
                <center>' . number_format($TotalDiamMedio, 1) . '</center>
            </td>
        </tr>
    </table>
    <br>
    <table class=" center" style="width: 100%;">
        <tr>
            <td>
                <h3 style="font-family:Arial, Helvetica, sans-serif">
                    3) Resumen Tiempos muertos del turno
                </h3>
            </td>
            <td style=" border: 0.05px solid black;font-size: 17px; font-family:Arial, Helvetica, sans-serif">
                <center>TM total: ' . $tiempomuertotalminutos . ' min</center>
            </td>
        </tr>
    </table>

    <br>
    <table class="center" style="border-collapse: collapse;width: 100%;border: 0.05px solid black;font-size: 17px; font-family:Arial, Helvetica, sans-serif">
        <tr>
            <td style=" border: 0.05px solid black;">
                <center>Item</center>
            </td>
            <td style=" border: 0.05px solid black;">Asignación de la operación</td>
            <td style=" border: 0.05px solid black;">
                <center>TM en min</center>
            </td>
            <td style=" border: 0.05px solid black;">
                <center>TM en %</center>
            </td>
        </tr>';

$queryresumtmtipo = "SELECT tipo_tiempo_muerto.nombre, ROUND(SUM(TIMESTAMPDIFF(SECOND,intermedia_errores.fecha_hora,intermedia_errores.fecha_termino))/60,1) AS minutos
FROM intermedia_maquina_error
INNER JOIN tiempos_muertos ON intermedia_maquina_error.id_error = tiempos_muertos.id_error 
INNER JOIN tipo_tiempo_muerto ON tipo_tiempo_muerto.id_tipo_tiempo_muerto = tiempos_muertos.id_tipo_tiempo_muerto 
INNER JOIN intermedia_errores ON intermedia_errores.id_inter_m_error = intermedia_maquina_error.id_inter_error_maquina 
WHERE intermedia_errores.id_inter_operacion = $id_inicio_operacion AND intermedia_errores.id_inter_m_error != 'null'
GROUP BY tipo_tiempo_muerto.nombre
ORDER BY tipo_tiempo_muerto.id_tipo_tiempo_muerto ASC;";
$resultResumtmtipo = mysqli_query($conexion, $queryresumtmtipo);
$count2 = 0;

while ($row = mysqli_fetch_array($resultResumtmtipo)) {
    $count2++;
    $fileContent .= '<tr>
            <td>
                <center>3.' . $count2 . '</center>
            </td>
            <td>
            TM ' . $row[0] . '
            </td>
            <td>
                <center> ' . $row[1] . '</center>
            </td>
            <td>
                <center>' . round(round($row[1] / $tiempomuertotalminutos, 5) * 100, 1) . '</center>
            </td>
        </tr>';
}

$count2 = $count2 + 1;
$tiemnoasig = round($tiempomuertocolacion + $minutostotalmuerto2, 1);
$fileContent .=     '<tr>
            <td>
                <center>3.' . $count2 . '</center>
            </td>
            <td>
                TM no asignados x operador
            </td>
            <td>
                <center>' . $tiemnoasig . '</center>
            </td>
            <td>
                <center>' . round(round($tiemnoasig / $tiempomuertotalminutos, 5) * 100, 1) . '</center>
            </td>
        </tr>
    </table>';


$fileContent .= '<div style="page-break-after:always;"></div>
    <table class=" center" style="width: 100%;">
        <tr>
            <td>
                <h3 style="font-family:Arial, Helvetica, sans-serif">
                    4) Detalle de tiempos muertos del turno
                </h3>
            </td>
        </tr>
    </table>

    <br>
    <table class="center" style="border-collapse: collapse; width: 100%;border: 0.05px solid black;font-size: 17px; font-family:Arial, Helvetica, sans-serif">
        <tr>
            <td style=" border: 0.05px solid black;">
                <center>Item</center>
            </td>
            <td style=" border: 0.05px solid black;">Asignación de la operación</td>
            <td style=" border: 0.05px solid black;">
                <center>Concepto</center>
            </td>
            <td style=" border: 0.05px solid black;">
            <center>Parte</center>
            </td>
            <td style=" border: 0.05px solid black;">
            <center>Componente</center>
            </td>
            <td style=" border: 0.05px solid black;">
                <center>TM <br> en min</center>
            </td>
            <td style=" border: 0.05px solid black;">
                <center>Frecuencia</center>
            </td>
        </tr>';

$queryresumtmtipo4 = "SELECT tipo_tiempo_muerto.nombre,tiempos_muertos.nombre,maquinas.nombre,componente.nombre,
ROUND(SUM(TIMESTAMPDIFF(SECOND,intermedia_errores.fecha_hora,intermedia_errores.fecha_termino))/60,1) AS minutos,
count(intermedia_errores.id_inter_error)
FROM intermedia_maquina_error
INNER JOIN tiempos_muertos ON intermedia_maquina_error.id_error = tiempos_muertos.id_error 
INNER JOIN tipo_tiempo_muerto ON tipo_tiempo_muerto.id_tipo_tiempo_muerto = tiempos_muertos.id_tipo_tiempo_muerto 
INNER JOIN intermedia_errores ON intermedia_errores.id_inter_m_error = intermedia_maquina_error.id_inter_error_maquina 
INNER JOIN maquinas ON intermedia_maquina_error.id_maquina = maquinas.id_maquina 
INNER JOIN componente ON intermedia_maquina_error.id_componente = componente.id_componente 
WHERE intermedia_errores.id_inter_operacion = $id_inicio_operacion AND intermedia_errores.id_inter_m_error != 'null'
GROUP BY tipo_tiempo_muerto.nombre,tiempos_muertos.nombre,maquinas.nombre,componente.nombre
ORDER BY tipo_tiempo_muerto.id_tipo_tiempo_muerto ASC;";
$resultResumtmtipo4 = mysqli_query($conexion, $queryresumtmtipo4);
$count4 = 0;
$tipotiem = "";
while ($rowtipo4 = mysqli_fetch_array($resultResumtmtipo4)) {

    $fileContent .= '<tr>';
    if ($tipotiem != $rowtipo4[0]) {
        $count4++;
        $tipotiem = $rowtipo4[0];
        $fileContent .= '<td style="border-left: thin solid; border-top: thin solid; border-bottom: thin solid;">
            <strong> <center>4.' . $count4 . '</center></strong>
            </td>
            <td style="border-top: thin solid; border-bottom: thin solid;">
            <strong>TM ' . $rowtipo4[0] . '</strong>
            </td>';
    } else {
        $fileContent .=  '<td style="border-left: thin solid; border-top: thin solid; border-bottom: thin solid;">
            <strong> <center></center></strong>
            </td>
            <td style="border-top: thin solid; border-bottom: thin solid;">
            <strong></strong>
            </td>';
    }
    $fileContent .= '<td style="border-top: thin solid; border-bottom: thin solid;">
                <center> ' . ucwords(mb_strtolower($rowtipo4[1])) . '</center>
            </td>
            <td style="border-top: thin solid; border-bottom: thin solid;">
            <center> ' .  ucwords(mb_strtolower($rowtipo4[2]))  . '</center>
            </td>
            <td style="border-top: thin solid; border-bottom: thin solid;">
            <center> ' .  ucwords(mb_strtolower($rowtipo4[3])) . '</center>
            </td>
            <td style="border-top: thin solid; border-bottom: thin solid;">
                <center>' .  ucwords(mb_strtolower($rowtipo4[4]))  . '</center>
            </td>
            <td style="border-top: thin solid; border-bottom: thin solid; border-right: thin solid;">
            <center> ' .  ucwords(mb_strtolower($rowtipo4[5]))  . '</center>
        </td>
        </tr>';
}

$count5 = $count4 + 1;
$fileContent .=     '<tr>
            <td style="border-left: thin solid; border-top: thin solid; border-bottom: thin solid;">
                <strong><center>4.' . $count5 . '</center></strong>
            </td>
            <td  style="border-top: thin solid; border-bottom: thin solid;">
            <strong> TM no asignados x operador</strong>
            </td>
            <td  style="border-top: thin solid; border-bottom: thin solid;">
                <center>Colación</center>
            </td>
            <td  style="border-top: thin solid; border-bottom: thin solid;">
                <center></center>
            </td>
            <td  style="border-top: thin solid; border-bottom: thin solid;">
            <center></center>
            </td>
            <td  style="border-top: thin solid; border-bottom: thin solid;">
            <center>' . $tiempomuertocolacion . '</center>
            </td>
            <td  style="border-top: thin solid; border-bottom: thin solid; border-right: thin solid;">
            <center>1</center>
            </td>
        </tr>';

$queryTiemMuertototal = "SELECT count(*)
FROM tiempo 
WHERE id_inicio_operacion = $id_inicio_operacion AND tipo_tiempo = 4 ORDER BY id_tiempo DESC LIMIT 1";
$resultTiemMuertototal = mysqli_query($conexion, $queryTiemMuertototal);
$rowTiemMuertototal = mysqli_fetch_row($resultTiemMuertototal);
$TiempoMuertototal = $rowTiemMuertototal[0];

$fileContent .=     '<tr>
            <td style="border-left: thin solid; border-top: thin solid; border-bottom: thin solid;">
                <center></center>
            </td>
            <td  style="border-top: thin solid; border-bottom: thin solid;">
              
            </td>
            <td  style="border-top: thin solid; border-bottom: thin solid;">
                <center>No asignados</center>
            </td>
            <td  style="border-top: thin solid; border-bottom: thin solid;">
                <center></center>
            </td>
            <td  style="border-top: thin solid; border-bottom: thin solid;">
            <center></center>
            </td>
            <td  style="border-top: thin solid; border-bottom: thin solid;">
            <center>' . $minutostotalmuerto2 . '</center>
            </td>
            <td  style="border-top: thin solid; border-bottom: thin solid; border-right: thin solid;">
            <center>' . $TiempoMuertototal . '</center>
            </td>
        </tr>
</table>
</body>

</html>';


$pdf->loadHtml($fileContent);
$pdf->setPaper('A4', 'portrait');


$pdf->render();
$pdf->stream($file_name, array('Attachment' => 1));
$file = $pdf->output();
file_put_contents($file_name, $file);

unlink($file_name);


// PDF POR CORREO
//$to          = "joelmanquilepe@gmail.com"; // addresses to email pdf to
//$from        = "exploratorioubb@betech.cl"; // address message is sent from
//$subject     = "Your PDF email subject"; // email subject
//$body        = "<p>The PDF is attached.</p>"; // email body
//$pdfLocation = $file_name; // file location
//$pdfName     = $file_name; // pdf file name recipient will get
//$filetype    = "application/pdf"; // type

// create headers and mime boundry
//$eol = PHP_EOL;
//$semi_rand     = md5(time());
//$mime_boundary = "==Multipart_Boundary_x{$semi_rand}x";
//$headers       = "From: $from$eol" .
 //   "MIME-Version: 1.0$eol" .
  //  "Content-Type: multipart/mixed;$eol" .
  //  " boundary=\"$mime_boundary\"";

// add html message body
//$message = "--$mime_boundary$eol" .
  //  "Content-Type: text/html; charset=\"iso-8859-1\"$eol" .
    //"Content-Transfer-Encoding: 7bit$eol$eol" .
    //$body . $eol;

// fetch pdf
//$file = fopen($pdfLocation, 'rb');
//$data = fread($file, filesize($pdfLocation));
//fclose($file);
//$pdf = chunk_split(base64_encode($data));

// attach pdf to email
//$message .= "--$mime_boundary$eol" .
//    "Content-Type: $filetype;$eol" .
 //   " name=\"$pdfName\"$eol" .
  //  "Content-Disposition: attachment;$eol" .
   // " filename=\"$pdfName\"$eol" .
   // "Content-Transfer-Encoding: base64$eol$eol" .
   // $pdf . $eol .
   // "--$mime_boundary--";

// Send the email
//if (mail($to, $subject, $message, $headers)) {
//    echo "The email was sent.";
//} else {
//    echo "There was an error sending the mail.";
//}
